<main id="main" class="main">
  <section class="section">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <title>Edit Zone</title>
            <style>
              #map { height: 500px; width: 100%; }
              #pac-input {
                margin-bottom: 10px;
              }
            </style>

            <h2 class="mb-3">Edit Zone</h2>
            <div class="row">
              <div class="col-md-6 mb-2">
                <label class="form-label">Zone Name</label>
                <input type="text" id="zone_name" class="form-control" value="<?= $zone[0]->name ?>" placeholder="Enter zone name" />
                <input type="hidden" id="zone_id" value="<?= $zone[0]->id ?>" />
              </div>

              <div class="col-md-6 mb-2">
                <label class="form-label">Hottest Zone</label>
                <select id="hottest_zone" class="form-control">
                  <option value="">Select Any Option</option>
                  <option value="yes" <?= $zone[0]->hottest_zone == "yes" ? 'selected' : '' ?>>Yes</option>
                  <option value="no" <?= $zone[0]->hottest_zone == "no" ? 'selected' : '' ?>>No</option>
                </select>
              </div>

              <div class="col-md-6 mb-2">
                <label class="form-label">Zone City</label>
                <select id="zone_city" class="form-control">
                  <option value="">Select Any City</option>
                  <?php foreach($cities as $city){ ?>
                    <option value="<?= $city->id ?>" <?= $zone[0]->zone_city == $city->id ? 'selected' : '' ?>>
                      <?= $city->city_name ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              
               <div class="col-md-6 mb-2">
                                        <label for="" class="form-label">Zone Logo</label>
                                       <input type="file" id="zone_logo" class="form-control" placeholder="" />
                                    </div>
                                    <div class="col-md-6 mb-2">
                                        <label for="" class="form-label">Zone Image</label>
                                       <input type="file" id="zone_pic" class="form-control" placeholder="" />
                                    </div>
                                    
            </div>

            <button onclick="submitZone()" class="btn btn-danger mt-2">Save Zone</button>

            <!-- 🔍 Location Search Box -->
            <input id="pac-input" class="form-control mt-3" type="text" placeholder="Search location..." />

            <div id="map" class="mt-2"></div>
            <input type="hidden" id="zoneData" />

            <!-- ✅ Add `places` to libraries -->
            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBoW1OUopUOYWo6yNRNuLHTBphvawo-qew&libraries=drawing,places"></script>
            <script>
              let map, drawingManager, selectedShape;

              function initMap() {
                map = new google.maps.Map(document.getElementById('map'), {
                  zoom: 10,
                  center: { lat: 17.385, lng: 78.486 }
                });

                // ✅ Setup Autocomplete
                const input = document.getElementById("pac-input");
                const autocomplete = new google.maps.places.Autocomplete(input);
                autocomplete.bindTo("bounds", map);

                // autocomplete.addListener("place_changed", function () {
                //   const place = autocomplete.getPlace();
                //   if (!place.geometry) {
                //     alert("No details available for input: '" + place.name + "'");
                //     return;
                //   }

                //   if (place.geometry.viewport) {
                //     map.fitBounds(place.geometry.viewport);
                //   } else {
                //     map.setCenter(place.geometry.location);
                //     map.setZoom(20);
                //   }
                // });
                
                autocomplete.addListener("place_changed", function () {
  const place = autocomplete.getPlace();
  if (!place.geometry) {
    alert("No details available for input: '" + place.name + "'");
    return;
  }

  if (place.geometry.viewport) {
    map.fitBounds(place.geometry.viewport);
    // Wait a moment before forcing zoom
    setTimeout(() => {
      map.setZoom(20);
    }, 500);
  } else {
    map.setCenter(place.geometry.location);
    map.setZoom(20);
  }
});


                drawingManager = new google.maps.drawing.DrawingManager({
                  drawingControl: true,
                  drawingControlOptions: {
                    position: google.maps.ControlPosition.TOP_CENTER,
                    drawingModes: ['polygon']
                  },
                  polygonOptions: {
                    editable: true,
                    fillColor: '#2196F3',
                    fillOpacity: 0.3,
                    strokeWeight: 2,
                    strokeColor: '#0D47A1'
                  }
                });

                drawingManager.setMap(map);

                const existingPolygon = <?= json_encode($boundaries) ?>;
                if (existingPolygon.length > 0) {
                  const path = existingPolygon.map(p => ({
                    lat: parseFloat(p.latitude),
                    lng: parseFloat(p.longitude)
                  }));

                  selectedShape = new google.maps.Polygon({
                    paths: path,
                    editable: true,
                    fillColor: '#2196F3',
                    fillOpacity: 0.3,
                    strokeWeight: 2,
                    strokeColor: '#0D47A1'
                  });

                  selectedShape.setMap(map);
                  map.setCenter(path[0]);
                  getPolygonCoordinates(selectedShape);

                  google.maps.event.addListener(selectedShape.getPath(), 'set_at', () => getPolygonCoordinates(selectedShape));
                  google.maps.event.addListener(selectedShape.getPath(), 'insert_at', () => getPolygonCoordinates(selectedShape));
                }

                google.maps.event.addListener(drawingManager, 'overlaycomplete', function(event) {
                  if (selectedShape) selectedShape.setMap(null);
                  selectedShape = event.overlay;
                  getPolygonCoordinates(selectedShape);
                  google.maps.event.addListener(selectedShape.getPath(), 'set_at', () => getPolygonCoordinates(selectedShape));
                  google.maps.event.addListener(selectedShape.getPath(), 'insert_at', () => getPolygonCoordinates(selectedShape));
                });
              }

              function getPolygonCoordinates(polygon) {
                const path = polygon.getPath();
                let coordinates = [];

                for (let i = 0; i < path.getLength(); i++) {
                  const latLng = path.getAt(i);
                  coordinates.push({ lat: latLng.lat(), lng: latLng.lng() });
                }

                document.getElementById("zoneData").value = JSON.stringify(coordinates);
              }

              function submitZone() {
                const name = document.getElementById("zone_name").value;
                const zone_id = document.getElementById("zone_id").value;
                const hottest_zone = document.getElementById("hottest_zone").value;
                const zone_city = document.getElementById("zone_city").value;
                const boundaries = document.getElementById("zoneData").value;
                
                 const zone_logo = document.getElementById("zone_logo").files[0]; // ✅ Use .files[0]
    const zone_pic = document.getElementById("zone_pic").files[0];

                if (!name || !zone_id || !hottest_zone || !zone_city || !boundaries) {
                  alert("Please fill all required fields and draw a zone.");
                  return;
                }

                const formData = new FormData();
                formData.append("zone_name", name);
                formData.append("zone_id", zone_id);
                formData.append("hottest_zone", hottest_zone);
                formData.append("zone_city", zone_city);
                formData.append("boundaries", boundaries);
                
                 formData.append("zone_logo", zone_logo); // ✅ File added
    formData.append("zone_pic", zone_pic);   // ✅ File added


                fetch("<?= base_url('welcome/update_zones') ?>", {
                  method: "POST",
                  body: formData
                })
                .then(res => res.json())
                .then(data => {
                  alert(data.message);
                  location.reload();
                })
                .catch(err => console.error("Error:", err));
              }

              window.onload = initMap;
            </script>
          </div>
        </div>
      </div>
    </div>
  </section>
</main>
