<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Mainmodel extends CI_Model
{
	
	
	public function login($username, $password)
	{
		//echo $password;exit;
		$this->db->select('*');
		$this->db->from('admin');
		$this->db->where('username', $username);
		$this->db->where('password', md5($password));		
		$query = $this->db->get();	
		// echo $this->db->last_query();exit;
		if ($query !== FALSE)
		{	
			if($query->num_rows() > 0){
				return $query->row();
			}else{
				return false;
			}
		}
		else
		{
			return false;
		}
    }
    
    	public function common_fetch($table,$where)
	{
		$this->db->select()->from($table);
		$this->db->where($where);
		$this->db->order_by("id","desc");
		$qry=$this->db->get();
		return $qry->result();
	}
	function common_insert($table,$data)
	{
	    $this->db->insert($table,$data);
	    return $this->db->insert_id();
	}
	function common_update($table,$data,$where)
	{
	    $this->db->where($where);
	    $this->db->update($table,$data);
	    return true;
	}
	function common_delete($table,$where)
	{
	    $this->db->where($where);
	    $this->db->delete($table);
	}
	
	    public function create_zone($zone_name, $boundaries,$hottest_zone,$zone_city,$pic,$logo) 
	    {
        $this->db->insert('zones', [
            'name' => $zone_name,
            'hottest_zone'=>$hottest_zone,
            'zone_logo'=>$logo,
            'zone_pic'=>$pic,
          'zone_city' => $zone_city,
            'created_on' => date('Y-m-d H:i:s')
            ]);
        $zone_id = $this->db->insert_id();

        foreach ($boundaries as $point) {
            $this->db->insert('zone_boundaries', [
                'zone_id' => $zone_id,
                'latitude' => $point['lat'],
                'longitude' => $point['lng'],
                'created_on' => date('Y-m-d H:i:s')
            ]);
        }

        return $zone_id;
    }
    
    public function get_all_activity_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('activities.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('activities.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('activities.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('activities.id');
            $this->db->from('activities');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('activities.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('activities.*,
    DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    CASE 
        WHEN activities.user_type = "pal" THEN "pal"
        WHEN activities.user_type = "par" THEN "partner"
        WHEN activities.user_type = "pro" THEN "professional"
        ELSE "Unknown"
    END AS user_type',false);

            $this->db->from('activities');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('activities.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_interest_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('interests.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('interests.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('interests.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('interests.id');
            $this->db->from('interests');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('interests.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('interests.*,
    DATE_FORMAT(interests.created_on, "%d-%m-%Y") AS created_on,
    CASE 
        WHEN interests.user_type = "pal" THEN "pal"
        WHEN interests.user_type = "par" THEN "partner"
        WHEN interests.user_type = "pro" THEN "professional"
        ELSE "Unknown"
    END AS user_type',false);

            $this->db->from('interests');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('interests.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_looking_for_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('looking_for.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('looking_for.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('looking_for.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('looking_for.id');
            $this->db->from('looking_for');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('looking_for.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('looking_for.*,
    DATE_FORMAT(looking_for.created_on, "%d-%m-%Y") AS created_on,
    CASE 
        WHEN looking_for.user_type = "pal" THEN "pal"
        WHEN looking_for.user_type = "par" THEN "partner"
        WHEN looking_for.user_type = "pro" THEN "professional"
        ELSE "Unknown"
    END AS user_type',false);

            $this->db->from('looking_for');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('looking_for.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_personality_traits_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('personality_traits.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('lookpersonality_traitsing_for.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('personality_traits.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('personality_traits.id');
            $this->db->from('personality_traits');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('personality_traits.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('personality_traits.*,
    DATE_FORMAT(personality_traits.created_on, "%d-%m-%Y") AS created_on,
    CASE 
        WHEN personality_traits.user_type = "pal" THEN "pal"
        WHEN personality_traits.user_type = "par" THEN "partner"
        WHEN personality_traits.user_type = "pro" THEN "professional"
        ELSE "Unknown"
    END AS user_type',false);

            $this->db->from('personality_traits');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('personality_traits.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
   public function get_all_preferences_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('preferences.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('preferences.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('preferences.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('preferences.id');
            $this->db->from('preferences');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('preferences.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('preferences.*,
    DATE_FORMAT(preferences.created_on, "%d-%m-%Y") AS created_on,
    CASE 
        WHEN preferences.user_type = "pal" THEN "pal"
        WHEN preferences.user_type = "par" THEN "partner"
        WHEN preferences.user_type = "pro" THEN "professional"
        ELSE "Unknown"
    END AS user_type',false);

            $this->db->from('preferences');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('preferences.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
   public function get_all_achievements_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('achievements.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('achievements.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('achievements.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('achievements.id');
            $this->db->from('achievements');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('achievements.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('achievements.*,
    DATE_FORMAT(achievements.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('achievements');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('achievements.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
  
   public function get_all_cities_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('cities.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('cities.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('cities.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('cities.id');
            $this->db->from('cities');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('cities.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('cities.*,
    DATE_FORMAT(cities.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('cities');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('cities.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
   public function get_all_foods_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('foods.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('foods.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('foods.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('foods.id');
            $this->db->from('foods');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('foods.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('foods.*,
    DATE_FORMAT(foods.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('foods');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('foods.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
   public function get_all_professional_connections_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('professional_connections.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('professional_connections.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('professional_connections.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('professional_connections.id');
            $this->db->from('professional_connections');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('professional_connections.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('professional_connections.*,
    DATE_FORMAT(professional_connections.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('professional_connections');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('professional_connections.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
   public function get_all_religions_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('religions.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('religions.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('religions.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('religions.id');
            $this->db->from('religions');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('religions.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('religions.*,
    DATE_FORMAT(religions.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('religions');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('religions.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
   
    public function get_all_languages_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('languages.language_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('languages.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('languages.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('languages.id');
            $this->db->from('languages');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('languages.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('languages.*,
    DATE_FORMAT(languages.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('languages');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('languages.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
     public function get_all_handles_details($pdata, $getcount=null)
    {
        if(isset($pdata['name'])!="" && !empty($pdata['name']))
        {
          $this->db->where('handles.handle_name', $pdata['name'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('handles.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('handles.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('handles.id');
            $this->db->from('handles');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('handles.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('handles.*,
    DATE_FORMAT(handles.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('handles');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('handles.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
  
   public function get_all_events_details($pdata, $getcount=null)
    {
        if(isset($pdata['name'])!="" && !empty($pdata['name']))
        {
          $this->db->like('events.event_name', $pdata['name'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('events.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('events.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('events.id');
            $this->db->from('events');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('events.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('events.*,cities.city_name,
    DATE_FORMAT(events.event_date, "%d-%m-%Y") AS event_date',false);

            $this->db->from('events');
          //  $this->db->join('cities','find_in_set(class.id, staff.employee_class)  > 0','left');
          $this->db->join('cities','cities.id  = events.event_city','left');
            $this->db->order_by('events.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
   
   public function get_all_subscriptions_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('subscriptions.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('subscriptions.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
     //  $this->db->where('subscriptions.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('subscriptions.id');
            $this->db->from('subscriptions');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('subscriptions.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('subscriptions.*,
    DATE_FORMAT(subscriptions.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('subscriptions');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('subscriptions.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
  
  
   public function get_all_zones_details($pdata, $getcount=null)
    {
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
            $from_date = $pdata['from_date']." 00:00:00";
          $this->db->where('zones.created_on >=', $from_date ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
               $to_date = $pdata['to_date']." 00:00:00";
              $this->db->where('zones.created_on <=', $to_date ); 
          }
          if(isset($pdata['zone_city'])!="" && !empty($pdata['zone_city']))
          {
              $this->db->where('zones.zone_city ', $pdata['zone_city'] ); 
          }
          if(isset($pdata['name'])!="" && !empty($pdata['name']))
          {
              $this->db->like('zones.name ', $pdata['name'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
     //  $this->db->where('subscriptions.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('zones.id');
            $this->db->from('zones');
           $this->db->join('cities','cities.id = zones.zone_city','left');
            $this->db->order_by('zones.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('zones.*,cities.city_name,
    DATE_FORMAT(zones.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('zones');
            $this->db->join('cities','cities.id = zones.zone_city','left');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('zones.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
     public function get_all_users_details($pdata, $getcount=null)
    {
        if(isset($pdata['name'])!="" && !empty($pdata['name']))
        {
            //echo $pdata['name'];exit;
          $this->db->like('users.name', $pdata['name'] ); 
          $this->db->or_like('users.mobile', $pdata['name'] ); 
          //$this->db->whrw('users.mobile', $pdata['name'] ); 
        }
    
          if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
          {
              $from_date = $pdata['from_date']." 00:00:00";
              $this->db->where('users.created_on >=',  $from_date); 
          }
           if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $to_date = $pdata['to_date']." 23:59:59";
              $this->db->where('users.created_on <=', $to_date ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('users.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('users.id');
            $this->db->from('users');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('users.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('users.*,
    DATE_FORMAT(users.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('users');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('users.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_payments_details($pdata, $getcount=null)
    {
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('users_sub_history.sub_date >=', $pdata['from_date'] ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('users_sub_history.sub_date <=', $pdata['to_date'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       //$this->db->where('users_sub_history.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('users_sub_history.id');
            $this->db->from('users_sub_history');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('users_sub_history.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('users_sub_history.*,users.name,users.mobile,subscriptions.sub_name,subscriptions.sub_type,
     DATE_FORMAT(users_sub_history.sub_date, "%d-%m-%Y") AS sub_date,
    DATE_FORMAT(users_sub_history.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('users_sub_history');
            $this->db->join('users','users.id = users_sub_history.user_id','left');
            $this->db->join('subscriptions','subscriptions.id = users_sub_history.sub_id','left');
            $this->db->order_by('users_sub_history.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
     public function get_all_user_contact_details($pdata, $getcount=null)
    {
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('contact_us_details.created_on >=', $pdata['from_date'] ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('contact_us_details.created_on <=', $pdata['to_date'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
     //  $this->db->where('subscriptions.delete_status', 1); 
        if($getcount)
        {
             $this->db->select('contact_us_details.id');
            $this->db->from('contact_us_details');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('contact_us_details.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
    //         $this->db->select('activities.*, 
    // DATE_FORMAT(activities.created_on, "%d-%m-%Y") AS created_on,
    // CASE 
    //     WHEN activities.user_type = "pal" THEN "pal"
    //     WHEN activities.user_type = "par" THEN "partner"
    //     WHEN activities.user_type = "pro" THEN "professional"
    //     ELSE "Unknown"
    // END AS user_type
            
    //         ');
    $this->db->select('contact_us_details.*,
    DATE_FORMAT(contact_us_details.created_on, "%d-%m-%Y") AS created_on',false);

            $this->db->from('contact_us_details');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('contact_us_details.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
  
  
   	public function get_total_payments_count()
   	{
   	    $this->db->select('SUM(users_sub_history.sub_amount) as total_sale');
   	    $this->db->from('users_sub_history');
   	    $result = $this->db->get()->row();
   	}
   	
  public function getAllActivePlayerIds() {
    $this->load->database();

    $query = $this->db->select('player_id')
                      ->from('users')
                      ->where('status', 1)
                      ->where('player_id !=', '')
                      ->where('player_id IS NOT NULL')
                      ->get();

    $results = $query->result_array();

    $playerIds = [];

    foreach ($results as $row) {
        if (preg_match('/^[a-f0-9\-]{36}$/', $row['player_id'])) {
            $playerIds[] = $row['player_id'];
        }
    }

    return $playerIds;
}


	
	
	
	
	
	
	
	
	
	

    

}//end of model