 <?php
// use Firebase\JWT\JWT;

// class Livekit_lib {

//     public function generateToken($userId, $roomName)
//     {
//         $apiKey = getenv('LIVEKIT_API_KEY');
//         $apiSecret = getenv('LIVEKIT_API_SECRET');

//         $now = time();

//         $payload = [
//             "iss" => $apiKey,
//             "sub" => "user_" . $userId,
//             "nbf" => $now,
//             "exp" => $now + 3600, // 1 hour
//             "video" => [
//                 "roomJoin" => true,
//                 "room" => $roomName,
//                 "canPublish" => true,
//                 "canSubscribe" => true
//             ]
//         ];

//         return JWT::encode($payload, $apiSecret, 'HS256');
//     }
// }



use Firebase\JWT\JWT;

class Livekit_lib {

    public function generateToken($userId, $roomName)
    {
        $apiKey = getenv('LIVEKIT_API_KEY');
        $apiSecret = getenv('LIVEKIT_API_SECRET');

        $now = time();

        $payload = [
            "iss" => $apiKey,
            "sub" => "user_" . $userId,
            "nbf" => $now,
            "exp" => $now + 3600,
            "video" => [
                "roomJoin" => true,
                "room" => $roomName,
                "canPublish" => true,
                "canSubscribe" => true
            ]
        ];

        return JWT::encode($payload, $apiSecret, 'HS256');
    }
}
