<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_model extends CI_Model {


    /*Commom Fetch*/
function common_fetch($table,$where){
	$this->db->select()->from($table);
	$this->db->where($where);
    $this->db->order_by('id','desc');
	$query= $this->db->get();
    return $query->result_array();
	 
}
/*Commom Fetch*/

/*common insert*/
function common_insert($table,$data)
{
    $this->db->insert($table,$data);
    $id = $this->db->insert_id();
    return $id;
} 
/*common insert */
/*commonpermanent delete */
public function common_p_delete($table,$data)
{
    $this->db->where($data);
$this->db->delete($table);
return true;

}
/*commonpermanent delete */
/*common update */
function common_update($table,$data,$where)
{
    $this->db->where($where);
    $this->db->update($table,$data);
   // $id = $this->db->insert_id();
   return true;
   // return $this->db->last_query();
}
/*common update */

public function get_all_activities($type)
{
    $this->db->select('activities.*');
    $this->db->from('activities');
    $this->db->where('activities.delete_status',1);
    $this->db->group_start();
    $this->db->where('activities.user_type',$type);
    $this->db->or_where('activities.user_type','all');
    $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

public function get_all_foods()
{
    $this->db->select('foods.*');
    $this->db->from('foods');
    $this->db->where('foods.delete_status',1);
   // $this->db->group_start();
   // $this->db->where('foods.user_type',$type);
   // $this->db->or_where('foods.user_type','all');
  //  $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

public function get_all_interests($type)
{
    $this->db->select('interests.*');
    $this->db->from('interests');
    $this->db->where('interests.delete_status',1);
    $this->db->group_start();
    $this->db->where('interests.user_type',$type);
    $this->db->or_where('interests.user_type','all');
    $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

public function get_all_looking_for($type)
{
    $this->db->select('looking_for.*');
    $this->db->from('looking_for');
    $this->db->where('looking_for.delete_status',1);
    $this->db->group_start();
    $this->db->where('looking_for.user_type',$type);
    $this->db->or_where('looking_for.user_type','all');
    $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

public function get_all_personality_traits($type)
{
    $this->db->select('personality_traits.*');
    $this->db->from('personality_traits');
    $this->db->where('personality_traits.delete_status',1);
    $this->db->group_start();
    $this->db->where('personality_traits.user_type',$type);
    $this->db->or_where('personality_traits.user_type','all');
    $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

public function get_all_preferences($type)
{
    $this->db->select('preferences.*');
    $this->db->from('preferences');
    $this->db->where('preferences.delete_status',1);
    $this->db->group_start();
    $this->db->where('preferences.user_type',$type);
    $this->db->or_where('preferences.user_type','all');
    $this->db->group_end();
    $query= $this->db->get();
    return $query->result_array();
}

public function get_pal_pics($user_id)
{
    $this->db->select('ui.*,,pl.created_on as date');
    $this->db->from('pal_registrations pl');
    $this->db->join('user_images ui','ui.user_type_id = pl.id AND ui.user_type = "pal" ','left');
    $this->db->where('pl.user_id',$user_id);
    $query= $this->db->get();
    return $query->result_array();
}
public function get_par_pics($user_id)
{
    $this->db->select('ui.*,,pl.created_on as date');
    $this->db->from('par_registrations pl');
    $this->db->join('user_images ui','ui.user_type_id = pl.id AND ui.user_type = "par" ','left');
    $this->db->where('pl.user_id',$user_id);
    $query= $this->db->get();
    return $query->result_array();
}
public function get_pro_pics($user_id)
{
    $this->db->select('ui.*,pl.created_on as date');
    $this->db->from('pro_registrations pl');
    $this->db->join('user_images ui','ui.user_type_id = pl.id AND ui.user_type = "pro" ','left');
    $this->db->where('pl.user_id',$user_id);
    $query= $this->db->get();
    return $query->result_array();
}

public function get_user_details_all($user_id)
{
    // (
    //         SELECT GROUP_CONCAT(DISTINCT l.language_name ORDER BY l.language_name SEPARATOR ", ")
    //         FROM user_languages ul
    //         JOIN languages l ON ul.language_id = l.id
    //         WHERE ul.user_id = u.id
    //     ) AS user_languages,
        
    $this->db->select('
        u.*,u.id as user_id,
        IFNULL(cf.city_name, "") as from_city_name,
        IFNULL(cs.city_name, "") as stay_city_name,
        IFNULL(re.religion_name, "") as religion_name,
        DATE_FORMAT(u.dob, "%d-%m-%Y") as dob,
        u.id as friend_id,
        
        
        (
    SELECT IFNULL(GROUP_CONCAT(DISTINCT l.language_name ORDER BY l.language_name SEPARATOR ", "), "") 
    FROM user_languages ul
    JOIN languages l ON ul.language_id = l.id
    WHERE ul.user_id = u.id
) AS user_languages,

(
    SELECT IFNULL(GROUP_CONCAT(ul.language_id ORDER BY ul.language_id SEPARATOR ", "), "") 
    FROM user_languages ul WHERE ul.user_id = u.id
) AS user_languages_ids,

        IF(u.sub_date IS NOT NULL, DATE_FORMAT(u.sub_date, "%d-%m-%Y"), "") AS sub_date
    ');
    
    $this->db->from('users u');
    $this->db->join('cities cf', 'u.from_city = cf.id', 'left');
    $this->db->join('cities cs', 'u.stay_city = cs.id', 'left');
    $this->db->join('religions re', 'u.religion = re.id', 'left');
    $this->db->where('u.id', $user_id);
    
    $query = $this->db->get();
    return $query->result_array();
}



// public function get_user_details_all($user_id)
// {
//     $this->db->select('u.*,IFNULL(cf.city_name,"") as from_city_name,IFNULL(cs.city_name, "") as stay_city_name,
//     IFNULL(re.religion_name, "") AS religion_name,
//     DATE_FORMAT(u.dob,"%d-%m-%Y") as dob,u.id as friend_id,
//   IFNULL((SELECT GROUP_CONCAT(DISTINCT fd.language_name ORDER BY fd.language_name SEPARATOR ", ") 
//          FROM user_languages uf 
//          JOIN languages fd ON uf.language_id = fd.id AND uf.user_id = '.$user_id.'
//          WHERE uf.language_id = fd.id), "") AS food_names,
//     IF(u.sub_date IS NOT NULL, "u.sub_date", "") AS sub_date');
//     $this->db->from('users u');
//     $this->db->join('cities cf','u.from_city = cf.id','left');
//     $this->db->join('cities cs','u.stay_city = cs.id','left');
//     $this->db->join('religions re', 'u.religion = re.id', 'left');
//   //  $this->db->join('user_languages ul', 'u.id = ul.user_id', 'left');
//  //   $this->db->join('languages la', 'la.id = ul.language_id', 'left');
//     $this->db->where('u.id',$user_id);
//     $query= $this->db->get();
//     return $query->result_array();
// }
// public function get_pal_details_all($user_id)
// {
    
//     $this->db->select('
        
        
//         pl.*, pl.id as user_type_id,IFNULL(re.religion_name, "") AS religion_name,
//         IFNULL(GROUP_CONCAT(DISTINCT lf.looking_for_name ORDER BY lf.looking_for_name SEPARATOR ", "), "") AS looking_for_names,
// IFNULL(GROUP_CONCAT(DISTINCT lf.id ORDER BY lf.id SEPARATOR ", "), "") AS looking_for_ids,
// IFNULL(GROUP_CONCAT(DISTINCT i.interest_name ORDER BY i.interest_name SEPARATOR ", "), "") AS interest_names,
// IFNULL(GROUP_CONCAT(DISTINCT i.id ORDER BY i.id SEPARATOR ", "), "") AS interest_ids,
// IFNULL(GROUP_CONCAT(DISTINCT pt.personality_traits_name ORDER BY pt.personality_traits_name SEPARATOR ", "), "") AS personality_traits_names,
// IFNULL(GROUP_CONCAT(DISTINCT pt.id ORDER BY pt.id SEPARATOR ", "), "") AS personality_traits_ids,
// IFNULL(GROUP_CONCAT(DISTINCT pr.preference_name ORDER BY pr.preference_name SEPARATOR ", "), "") AS preference_names,
// IFNULL(GROUP_CONCAT(DISTINCT pr.id ORDER BY pr.id SEPARATOR ", "), "") AS preference_ids,
// IFNULL(GROUP_CONCAT(DISTINCT fd.food_name ORDER BY fd.food_name SEPARATOR ", "), "") AS food_names,
// IFNULL(GROUP_CONCAT(DISTINCT fd.id ORDER BY fd.id SEPARATOR ", "), "") AS food_ids,
// IFNULL(GROUP_CONCAT(DISTINCT ac.activity_name ORDER BY ac.activity_name SEPARATOR ", "), "") AS activity_names,
// IFNULL(GROUP_CONCAT(DISTINCT ac.id ORDER BY ac.id SEPARATOR ", "), "") AS activity_ids
//     ');
//     $this->db->from('pal_registrations pl');
//     $this->db->join('religions re', 'pl.religion = re.id', 'left');
//     $this->db->join('user_looking_for ulf', 'pl.id = ulf.user_type_id AND ulf.user_type = "pal"', 'left');
//     $this->db->join('looking_for lf', 'ulf.looking_for_id = lf.id', 'left');
//     $this->db->join('user_interests ui', 'pl.id = ui.user_type_id AND ui.user_type = "pal"', 'left');
//     $this->db->join('interests i', 'ui.interest_id = i.id', 'left');
//     $this->db->join('user_personality_traits upt', 'pl.id = upt.user_type_id AND upt.user_type = "pal"', 'left');
//     $this->db->join('personality_traits pt', 'upt.personality_traits_id = pt.id', 'left');
//     $this->db->join('user_preferences upr', 'pl.id = upr.user_type_id AND upr.user_type = "pal"', 'left');
//     $this->db->join('preferences pr', 'upr.preference_id = pr.id', 'left');
//     $this->db->join('user_food uf', 'pl.id = uf.user_type_id AND uf.user_type = "pal"', 'left');
//     $this->db->join('foods fd', 'uf.food_id = fd.id', 'left');
//     $this->db->join('user_activities ua', 'pl.id = ua.user_type_id AND ua.user_type = "pal"', 'left');
//     $this->db->join('activities ac', 'ua.activity_id = ac.id', 'left');
//     $this->db->where('pl.user_id', $user_id);
//     $this->db->group_by('pl.id');
//     $query = $this->db->get();
//     // echo $this->db->last_query();exit;
//     return $query->result_array();
// }
 // pl.introvert_extravert_ambivort,
public function get_pal_details_all($user_id)
{
    $this->db->select('
        pl.id as user_type_id,pl.about,pl.designation,pl.workplace_institution,
      
        CONCAT(UCASE(LEFT(pl.introvert_extravert_ambivort, 1)), SUBSTRING(pl.introvert_extravert_ambivort, 2)) AS introvert_extravert_ambivort,
        
        

        IFNULL((SELECT GROUP_CONCAT(DISTINCT lf.looking_for_name ORDER BY lf.looking_for_name SEPARATOR ", ") 
         FROM user_looking_for ulf 
         JOIN looking_for lf ON ulf.looking_for_id = lf.id 
         WHERE ulf.user_type_id = pl.id AND ulf.user_type = "pal"), "") AS looking_for_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT lf.id ORDER BY lf.id SEPARATOR ", ") 
         FROM user_looking_for ulf 
         JOIN looking_for lf ON ulf.looking_for_id = lf.id 
         WHERE ulf.user_type_id = pl.id AND ulf.user_type = "pal"), "") AS looking_for_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT i.interest_name ORDER BY i.interest_name SEPARATOR ", ") 
         FROM user_interests ui 
         JOIN interests i ON ui.interest_id = i.id 
         WHERE ui.user_type_id = pl.id AND ui.user_type = "pal"), "") AS interest_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT i.id ORDER BY i.id SEPARATOR ", ") 
         FROM user_interests ui 
         JOIN interests i ON ui.interest_id = i.id 
         WHERE ui.user_type_id = pl.id AND ui.user_type = "pal"), "") AS interest_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pt.personality_traits_name ORDER BY pt.personality_traits_name SEPARATOR ", ") 
         FROM user_personality_traits upt 
         JOIN personality_traits pt ON upt.personality_traits_id = pt.id 
         WHERE upt.user_type_id = pl.id AND upt.user_type = "pal"), "") AS personality_traits_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pt.id ORDER BY pt.id SEPARATOR ", ") 
         FROM user_personality_traits upt 
         JOIN personality_traits pt ON upt.personality_traits_id = pt.id 
         WHERE upt.user_type_id = pl.id AND upt.user_type = "pal"), "") AS personality_traits_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pr.preference_name ORDER BY pr.preference_name SEPARATOR ", ") 
         FROM user_preferences upr 
         JOIN preferences pr ON upr.preference_id = pr.id 
         WHERE upr.user_type_id = pl.id AND upr.user_type = "pal"), "") AS preference_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pr.id ORDER BY pr.id SEPARATOR ", ") 
         FROM user_preferences upr 
         JOIN preferences pr ON upr.preference_id = pr.id 
         WHERE upr.user_type_id = pl.id AND upr.user_type = "pal"), "") AS preference_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT fd.food_name ORDER BY fd.food_name SEPARATOR ", ") 
         FROM user_food uf 
         JOIN foods fd ON uf.food_id = fd.id 
         WHERE uf.user_type_id = pl.id AND uf.user_type = "pal"), "") AS food_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT fd.id ORDER BY fd.id SEPARATOR ", ") 
         FROM user_food uf 
         JOIN foods fd ON uf.food_id = fd.id 
         WHERE uf.user_type_id = pl.id AND uf.user_type = "pal"), "") AS food_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT ac.activity_name ORDER BY ac.activity_name SEPARATOR ", ") 
         FROM user_activities ua 
         JOIN activities ac ON ua.activity_id = ac.id 
         WHERE ua.user_type_id = pl.id AND ua.user_type = "pal"), "") AS activity_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT ac.id ORDER BY ac.id SEPARATOR ", ") 
         FROM user_activities ua 
         JOIN activities ac ON ua.activity_id = ac.id 
         WHERE ua.user_type_id = pl.id AND ua.user_type = "pal"), "") AS activity_ids
    ');
    
    $this->db->from('pal_registrations pl');
    $this->db->join('religions re', 'pl.religion = re.id', 'left');
    $this->db->where('pl.user_id', $user_id);
    $this->db->group_by('pl.id');
    
    $query = $this->db->get();
    return $query->result_array();
}


// public function get_pal_details_all($user_id)
// {
//     // Step 1: Fetch base profile + joined cities + religion
//     $pal = $this->db
//         ->select('
//             pl.*, pl.id as user_type_id,
//             IFNULL(re.religion_name, "") AS religion_name
//             ')
//         ->from('pal_registrations pl')
//         ->join('religions re', 'pl.religion = re.id', 'left')
//         ->where('pl.user_id', $user_id)
//         ->get()
//         ->row_array();

//     if (!$pal) {
//         return [
//             'status' => false,
//             'message' => 'User not found',
//             'response' => []
//         ];
//     }

//     $user_type_id = $pal['user_type_id'];
//     $user_type = 'pal';

//     // Step 2: Attach group values
//     $pal += $this->get_grouped_values('user_looking_for', 'looking_for', 'looking_for_id', $user_type_id, $user_type, 'looking_for');
//     $pal += $this->get_grouped_values('user_interests', 'interests', 'interest_id', $user_type_id, $user_type, 'interest');
//     $pal += $this->get_grouped_values('user_personality_traits', 'personality_traits', 'personality_traits_id', $user_type_id, $user_type, 'personality_traits');
//     $pal += $this->get_grouped_values('user_preferences', 'preferences', 'preference_id', $user_type_id, $user_type, 'preference');
//     $pal += $this->get_grouped_values('user_food', 'foods', 'food_id', $user_type_id, $user_type, 'food');
//     $pal += $this->get_grouped_values('user_activities', 'activities', 'activity_id', $user_type_id, $user_type, 'activity');

//     // Step 3: Attach pictures
//     $pal['pics'] = $this->db
//         ->select('id, user_type, user_type_id, image_link, created_on')
//         ->from('user_pics')
//         ->where('user_type_id', $user_type_id)
//         ->where('user_type', $user_type)
//         ->order_by('id', 'DESC')
//         ->get()
//         ->result_array();

//     // Step 4: Return formatted response
//     return [
//         'status' => true,
//         'message' => 'User Profile Details',
//         'response' => $pal
//     ];
// }
// private function get_grouped_values($pivot_table, $main_table, $foreign_key, $user_type_id, $user_type, $alias_prefix)
// {
//     $query = $this->db
//         ->select("
//             GROUP_CONCAT(DISTINCT $main_table.$main_table" . "_name SEPARATOR ', ') AS {$alias_prefix}_names,
//             GROUP_CONCAT(DISTINCT $main_table.id SEPARATOR ', ') AS {$alias_prefix}_ids
//         ")
//         ->from($pivot_table)
//         ->join($main_table, "$pivot_table.$foreign_key = $main_table.id", 'left')
//         ->where("$pivot_table.user_type_id", $user_type_id)
//         ->where("$pivot_table.user_type", $user_type)
//         ->get()
//         ->row_array();

//     return [
//         "{$alias_prefix}_names" => $query["{$alias_prefix}_names"] ?? '',
//         "{$alias_prefix}_ids" => $query["{$alias_prefix}_ids"] ?? ''
//     ];
// }
// public function get_par_details_all($user_id)
// {
//     $this->db->select('pl.*, pl.id as user_type_id,IFNULL(re.religion_name, "") AS religion_name,
//         IFNULL(GROUP_CONCAT(DISTINCT lf.looking_for_name ORDER BY lf.looking_for_name SEPARATOR ", "), "") AS looking_for_names,
// IFNULL(GROUP_CONCAT(DISTINCT lf.id ORDER BY lf.id SEPARATOR ", "), "") AS looking_for_ids,
// IFNULL(GROUP_CONCAT(DISTINCT i.interest_name ORDER BY i.interest_name SEPARATOR ", "), "") AS interest_names,
// IFNULL(GROUP_CONCAT(DISTINCT i.id ORDER BY i.id SEPARATOR ", "), "") AS interest_ids,
// IFNULL(GROUP_CONCAT(DISTINCT pt.personality_traits_name ORDER BY pt.personality_traits_name SEPARATOR ", "), "") AS personality_traits_names,
// IFNULL(GROUP_CONCAT(DISTINCT pt.id ORDER BY pt.id SEPARATOR ", "), "") AS personality_traits_ids,
// IFNULL(GROUP_CONCAT(DISTINCT pr.preference_name ORDER BY pr.preference_name SEPARATOR ", "), "") AS preference_names,
// IFNULL(GROUP_CONCAT(DISTINCT pr.id ORDER BY pr.id SEPARATOR ", "), "") AS preference_ids,
// IFNULL(GROUP_CONCAT(DISTINCT fd.food_name ORDER BY fd.food_name SEPARATOR ", "), "") AS food_names,
// IFNULL(GROUP_CONCAT(DISTINCT fd.id ORDER BY fd.id SEPARATOR ", "), "") AS food_ids,
// IFNULL(GROUP_CONCAT(DISTINCT ac.activity_name ORDER BY ac.activity_name SEPARATOR ", "), "") AS activity_names,
// IFNULL(GROUP_CONCAT(DISTINCT ac.id ORDER BY ac.id SEPARATOR ", "), "") AS activity_ids
// ');
//     $this->db->from('par_registrations pl');
//     $this->db->join('religions re', 'pl.religion = re.id', 'left');
//     $this->db->join('user_looking_for ulf', 'pl.id = ulf.user_type_id AND ulf.user_type = "par"', 'left');
//     $this->db->join('looking_for lf', 'ulf.looking_for_id = lf.id', 'left');
//     $this->db->join('user_interests ui', 'pl.id = ui.user_type_id AND ui.user_type = "par"', 'left');
//     $this->db->join('interests i', 'ui.interest_id = i.id', 'left');
//     $this->db->join('user_personality_traits upt', 'pl.id = upt.user_type_id AND upt.user_type = "par"', 'left');
//     $this->db->join('personality_traits pt', 'upt.personality_traits_id = pt.id', 'left');
//     $this->db->join('user_preferences upr', 'pl.id = upr.user_type_id AND upr.user_type = "par"', 'left');
//     $this->db->join('preferences pr', 'upr.preference_id = pr.id', 'left');
//     $this->db->join('user_food uf', 'pl.id = uf.user_type_id AND uf.user_type = "par"', 'left');
//     $this->db->join('foods fd', 'uf.food_id = fd.id', 'left');
//     $this->db->join('user_activities ua', 'pl.id = ua.user_type_id AND ua.user_type = "par"', 'left');
//     $this->db->join('activities ac', 'ua.activity_id = ac.id', 'left');
//     $this->db->where('pl.user_id', $user_id);
//     $this->db->group_by('pl.id');
//     $query = $this->db->get();
   
//     return $query->result_array();
// }

public function get_par_details_all($user_id)
{
    $this->db->select('pl.id as user_type_id,pl.about,pl.designation,pl.workplace_institution,
        
        CONCAT(UCASE(LEFT(pl.introvert_extravert_ambivort, 1)), SUBSTRING(pl.introvert_extravert_ambivort, 2)) AS introvert_extravert_ambivort,
       
        IFNULL((SELECT GROUP_CONCAT(DISTINCT lf.looking_for_name ORDER BY lf.looking_for_name SEPARATOR ", ")
            FROM user_looking_for ulf 
            JOIN looking_for lf ON ulf.looking_for_id = lf.id 
            WHERE ulf.user_type_id = pl.id AND ulf.user_type = "par"), "") AS looking_for_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT lf.id ORDER BY lf.id SEPARATOR ", ")
            FROM user_looking_for ulf 
            JOIN looking_for lf ON ulf.looking_for_id = lf.id 
            WHERE ulf.user_type_id = pl.id AND ulf.user_type = "par"), "") AS looking_for_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT i.interest_name ORDER BY i.interest_name SEPARATOR ", ")
            FROM user_interests ui 
            JOIN interests i ON ui.interest_id = i.id 
            WHERE ui.user_type_id = pl.id AND ui.user_type = "par"), "") AS interest_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT i.id ORDER BY i.id SEPARATOR ", ")
            FROM user_interests ui 
            JOIN interests i ON ui.interest_id = i.id 
            WHERE ui.user_type_id = pl.id AND ui.user_type = "par"), "") AS interest_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pt.personality_traits_name ORDER BY pt.personality_traits_name SEPARATOR ", ")
            FROM user_personality_traits upt 
            JOIN personality_traits pt ON upt.personality_traits_id = pt.id 
            WHERE upt.user_type_id = pl.id AND upt.user_type = "par"), "") AS personality_traits_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pt.id ORDER BY pt.id SEPARATOR ", ")
            FROM user_personality_traits upt 
            JOIN personality_traits pt ON upt.personality_traits_id = pt.id 
            WHERE upt.user_type_id = pl.id AND upt.user_type = "par"), "") AS personality_traits_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pr.preference_name ORDER BY pr.preference_name SEPARATOR ", ")
            FROM user_preferences upr 
            JOIN preferences pr ON upr.preference_id = pr.id 
            WHERE upr.user_type_id = pl.id AND upr.user_type = "par"), "") AS preference_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT pr.id ORDER BY pr.id SEPARATOR ", ")
            FROM user_preferences upr 
            JOIN preferences pr ON upr.preference_id = pr.id 
            WHERE upr.user_type_id = pl.id AND upr.user_type = "par"), "") AS preference_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT fd.food_name ORDER BY fd.food_name SEPARATOR ", ")
            FROM user_food uf 
            JOIN foods fd ON uf.food_id = fd.id 
            WHERE uf.user_type_id = pl.id AND uf.user_type = "par"), "") AS food_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT fd.id ORDER BY fd.id SEPARATOR ", ")
            FROM user_food uf 
            JOIN foods fd ON uf.food_id = fd.id 
            WHERE uf.user_type_id = pl.id AND uf.user_type = "par"), "") AS food_ids,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT ac.activity_name ORDER BY ac.activity_name SEPARATOR ", ")
            FROM user_activities ua 
            JOIN activities ac ON ua.activity_id = ac.id 
            WHERE ua.user_type_id = pl.id AND ua.user_type = "par"), "") AS activity_names,

        IFNULL((SELECT GROUP_CONCAT(DISTINCT ac.id ORDER BY ac.id SEPARATOR ", ")
            FROM user_activities ua 
            JOIN activities ac ON ua.activity_id = ac.id 
            WHERE ua.user_type_id = pl.id AND ua.user_type = "par"), "") AS activity_ids
    ');

    $this->db->from('par_registrations pl');
    $this->db->join('religions re', 'pl.religion = re.id', 'left');
    $this->db->where('pl.user_id', $user_id);
    $this->db->group_by('pl.id');

    $query = $this->db->get();
    return $query->result_array();
}
public function get_pro_details_all($user_id)
{
    $this->db->select('pl.id as user_type_id, pl.user_id as user_id, IFNULL(pl.about,"") as about,
    pl.title,pl.industry,pl.experience,pl.education,pl.location, pl.website,
    
    
    IFNULL(GROUP_CONCAT(DISTINCT lf.looking_for_name ORDER BY lf.looking_for_name SEPARATOR ", "), "") AS looking_for_names,
IFNULL(GROUP_CONCAT(DISTINCT lf.id ORDER BY lf.id SEPARATOR ", "), "") AS looking_for_ids,
IFNULL(GROUP_CONCAT(DISTINCT i.interest_name ORDER BY i.interest_name SEPARATOR ", "), "") AS interest_names,
IFNULL(GROUP_CONCAT(DISTINCT i.id ORDER BY i.id SEPARATOR ", "), "") AS interest_ids,
IFNULL(GROUP_CONCAT(DISTINCT pt.achievement_name ORDER BY pt.achievement_name SEPARATOR ", "), "") AS achievement_names,
IFNULL(GROUP_CONCAT(DISTINCT pt.id ORDER BY pt.id SEPARATOR ", "), "") AS achievement_ids,
IFNULL(GROUP_CONCAT(DISTINCT pr.connection_name ORDER BY pr.connection_name SEPARATOR ", "), "") AS connection_names,
IFNULL(GROUP_CONCAT(DISTINCT pr.id ORDER BY pr.id SEPARATOR ", "), "") AS connection_ids
        ');
        //  GROUP_CONCAT(DISTINCT lf.looking_for_name ORDER BY lf.looking_for_name SEPARATOR ", ") AS looking_for_names,
        // GROUP_CONCAT(DISTINCT lf.id ORDER BY lf.id SEPARATOR ", ") AS looking_for_ids,
        // GROUP_CONCAT(DISTINCT i.interest_name ORDER BY i.interest_name SEPARATOR ", ") AS interest_names,
        // GROUP_CONCAT(DISTINCT i.id ORDER BY i.id SEPARATOR ", ") AS interest_ids,
        // GROUP_CONCAT(DISTINCT pt.achievement_name ORDER BY pt.achievement_name SEPARATOR ", ") AS achievement_names,
        // GROUP_CONCAT(DISTINCT pt.id ORDER BY pt.id SEPARATOR ", ") AS achievement_ids,
        // GROUP_CONCAT(DISTINCT pr.connection_name ORDER BY pr.connection_name SEPARATOR ", ") AS connection_names,
        // GROUP_CONCAT(DISTINCT pr.id ORDER BY pr.id SEPARATOR ", ") AS connection_ids
       
    $this->db->from('pro_registrations pl');
   // $this->db->join('religions re', 'pl.religion = re.id', 'left');
    $this->db->join('user_looking_for ulf', 'pl.id = ulf.user_type_id AND ulf.user_type = "pro"', 'left');
    $this->db->join('looking_for lf', 'ulf.looking_for_id = lf.id', 'left');
    $this->db->join('user_interests ui', 'pl.id = ui.user_type_id AND ui.user_type = "pro"', 'left');
    $this->db->join('interests i', 'ui.interest_id = i.id', 'left');
    $this->db->join('user_achievements upt', 'pl.id = upt.user_type_id AND upt.user_type = "pro"', 'left');
    $this->db->join('achievements pt', 'upt.achievement_id = pt.id', 'left');
    $this->db->join('user_professional_connections upr', 'pl.id = upr.user_type_id AND upr.user_type = "pro"', 'left');
    $this->db->join('professional_connections pr', 'upr.professional_connection_id = pr.id', 'left');
    $this->db->where('pl.user_id', $user_id);
    $this->db->group_by('pl.id');
    $query = $this->db->get();
    return $query->result_array();
}

public function get_user_profiles($id)
{
    $this->db->select('u.id');
    $this->db->select("CASE 
        WHEN 
            (EXISTS (SELECT 1 FROM pal_registrations t1 WHERE t1.user_id = u.id)) 
            OR (EXISTS (SELECT 1 FROM par_registrations t2 WHERE t2.user_id = u.id)) 
            OR (EXISTS (SELECT 1 FROM pro_registrations t3 WHERE t3.user_id = u.id))
        THEN 'Yes'
        ELSE 'No'
    END AS has_data", false); // important: false to prevent escaping

    $this->db->from('users u');
    $this->db->where('u.id', $id);

    $query = $this->db->get();
    $result = $query->row_array(); // return one row as array

    return $result;
}


// public function is_point_in_zone($latitude, $longitude) {
//     $zones = $this->get_all_zones_with_boundaries();
//     $matched_zones = [];

//     foreach ($zones as $zone) {
//         $polygon = array_map(function ($point) {
//             return [$point['latitude'], $point['longitude']];
//         }, $zone['boundaries']);

//         if ($this->is_point_in_polygon([$latitude, $longitude], $polygon)) {
//             $matched_zones[] = (object)[ 'id' => $zone['id'], 'name' => $zone['name'] ];
//         }
//     }

//     return $matched_zones;
// }

// private function is_point_in_polygon($point, $polygon) {
//     $x = $point[0];
//     $y = $point[1];
//     $inside = false;

//     $n = count($polygon);
//     for ($i = 0, $j = $n - 1; $i < $n; $j = $i++) {
//         $xi = $polygon[$i][0]; $yi = $polygon[$i][1];
//         $xj = $polygon[$j][0]; $yj = $polygon[$j][1];

//         $intersect = (($yi > $y) != ($yj > $y)) &&
//                      ($x < ($xj - $xi) * ($y - $yi) / ($yj - $yi + 0.0000001) + $xi);

//         if ($intersect) $inside = !$inside;
//     }

//     return $inside;
// }

// Function to check if a point is inside a polygon using Ray Casting Algorithm
private function is_point_in_polygon($point, $polygon) {
    $x = $point[0];
    $y = $point[1];
    $inside = false;

    $n = count($polygon);
    for ($i = 0, $j = $n - 1; $i < $n; $j = $i++) {
        $xi = $polygon[$i][0];
        $yi = $polygon[$i][1];
        $xj = $polygon[$j][0];
        $yj = $polygon[$j][1];

        $intersect = (($yi > $y) != ($yj > $y)) &&
                     ($x < (($xj - $xi) * ($y - $yi) / (($yj - $yi) + 0.0000001) + $xi));

        if ($intersect) {
            $inside = !$inside;
        }
    }

    return $inside;
}

// Function to check if given latitude and longitude lie within any zone polygon
// public function is_point_in_zone($latitude, $longitude) {
//     // Round to 6 decimal places for consistent precision
//     $latitude = round($latitude, 6);
//     $longitude = round($longitude, 6);

//     $zones = $this->get_all_zones_with_boundaries(); // Get zones from DB or source
//     $matched_zones = [];

//     foreach ($zones as $zone) {
//         // Convert each boundary point to [lat, lon] and round to 6 decimal places
//         $polygon = array_map(function ($point) {
//             return [round($point['latitude'], 6), round($point['longitude'], 6)];
//         }, $zone['boundaries']);

//         // Optional: Ensure polygon is closed
//         if ($polygon[0] !== end($polygon)) {
//             $polygon[] = $polygon[0];
//         }

//         // Check if the given point lies inside the current zone's polygon
//         if ($this->is_point_in_polygon([$latitude, $longitude], $polygon)) 
//         {
//             $matched_zones[] = (object)[
//                 'id' => $zone['id'],
//                 'name' => $zone['name']
//             ];
//         }
//     }

//     return $matched_zones;
// }


// public function get_all_zones_with_boundaries() {
//     $zones = $this->db->where(array('delete_status' => 1,
//     'status' => 1))->get('zones')->result_array();
//     foreach ($zones as &$zone) {
//         $zone['boundaries'] = $this->db->get_where('zone_boundaries', ['zone_id' => $zone['id']])->result_array();
//     }
//     return $zones;
// }


public function is_point_in_zone($latitude, $longitude) {
    // Round to 6 decimal places for consistent precision
    $latitude = round($latitude, 6);
    $longitude = round($longitude, 6);

    $zones = $this->get_all_zones_with_boundaries(); // Get zones from DB or source
    $matched_zones = [];

    foreach ($zones as $zone) {
        // Convert each boundary point to [lat, lon] and round to 6 decimal places
        $polygon = array_map(function ($point) {
            return [round($point['latitude'], 6), round($point['longitude'], 6)];
        }, $zone['boundaries']);

        // Optional: Ensure polygon is closed
        if ($polygon[0] !== end($polygon)) {
            $polygon[] = $polygon[0];
        }

        // Check if the given point lies inside the current zone's polygon
        if ($this->is_point_in_polygon([$latitude, $longitude], $polygon)) 
        {
            $matched_zones[] = (object)[
                'id' => $zone['id'],
                'name' => $zone['name']
            ];
        }
    }

    return $matched_zones;
}


public function get_all_zones_with_boundaries() {
    $zones = $this->db->where(array('delete_status' => 1,
    'status' => 1))->get('zones')->result_array();
    foreach ($zones as &$zone) {
        $zone['boundaries'] = $this->db->get_where('zone_boundaries', ['zone_id' => $zone['id']])->result_array();
    }
    return $zones;
}


public function is_user_in_zone($lat, $lon, $zone_id) {
    // Get all boundary points for the zone
    $boundaries = $this->db
        ->select('latitude, longitude')
        ->where('zone_id', $zone_id)
        ->get('zone_boundaries')
        ->result_array();

    if (empty($boundaries)) {
        return false; // No boundaries found
    }

    // Build the polygon
    $polygon = array_map(function ($point) {
        return [$point['latitude'], $point['longitude']];
    }, $boundaries);

    // Check if user is inside the polygon
    return $this->is_point_in_polygon_inzone([$lat, $lon], $polygon);
}

private function is_point_in_polygon_inzone($point, $polygon) {
    $x = $point[0];
    $y = $point[1];
    $inside = false;

    $n = count($polygon);
    for ($i = 0, $j = $n - 1; $i < $n; $j = $i++) {
        $xi = $polygon[$i][0]; $yi = $polygon[$i][1];
        $xj = $polygon[$j][0]; $yj = $polygon[$j][1];

        $intersect = (($yi > $y) != ($yj > $y)) &&
                     ($x < ($xj - $xi) * ($y - $yi) / (($yj - $yi) ?: 0.0000001) + $xi);

        if ($intersect) $inside = !$inside;
    }

    return $inside;
}

public function is_user_in_zone_new($lat, $lon, $zone_id) {
    // Get all boundary points for the zone
    $boundaries = $this->db
        ->select('latitude, longitude')
        ->where('zone_id', $zone_id)
        ->get('zone_boundaries')
        ->result_array();

    if (empty($boundaries)) {
        return false; // No boundaries found
    }

    // Build the polygon
    $polygon = array_map(function ($point) {
        return [$point['latitude'], $point['longitude']];
    }, $boundaries);

    // Check if point is inside polygon
    $inside = $this->is_point_in_polygon_inzone_new([$lat, $lon], $polygon);

    // If not inside, check if within 10 meters of boundary
    if (!$inside) {
        $distance = $this->distance_to_polygon_boundary([$lat, $lon], $polygon);
        if ($distance <= 10) { // within 10 meters
            $inside = true;
        }
    }

    return $inside;
}

private function is_point_in_polygon_inzone_new($point, $polygon) {
    $x = $point[0];
    $y = $point[1];
    $inside = false;

    $n = count($polygon);
    for ($i = 0, $j = $n - 1; $i < $n; $j = $i++) {
        $xi = $polygon[$i][0]; $yi = $polygon[$i][1];
        $xj = $polygon[$j][0]; $yj = $polygon[$j][1];

        $intersect = (($yi > $y) != ($yj > $y)) &&
                     ($x < ($xj - $xi) * ($y - $yi) / (($yj - $yi) ?: 0.0000001) + $xi);

        if ($intersect) $inside = !$inside;
    }

    return $inside;
}

// ✅ Compute minimum distance from point to polygon edges (in meters)
private function distance_to_polygon_boundary($point, $polygon) {
    $minDistance = INF;
    $n = count($polygon);

    for ($i = 0; $i < $n; $i++) {
        $j = ($i + 1) % $n;
        $dist = $this->point_to_segment_distance(
            $point[0], $point[1],
            $polygon[$i][0], $polygon[$i][1],
            $polygon[$j][0], $polygon[$j][1]
        );
        if ($dist < $minDistance) $minDistance = $dist;
    }

    return $minDistance;
}

// ✅ Haversine-based shortest distance from point to line segment
private function point_to_segment_distance($lat, $lon, $lat1, $lon1, $lat2, $lon2) {
    // Convert to radians
    $R = 6371000; // Earth radius (m)
    $lat = deg2rad($lat);
    $lon = deg2rad($lon);
    $lat1 = deg2rad($lat1);
    $lon1 = deg2rad($lon1);
    $lat2 = deg2rad($lat2);
    $lon2 = deg2rad($lon2);

    // Convert to Cartesian coordinates
    $A = [$R * cos($lat1) * cos($lon1), $R * cos($lat1) * sin($lon1), $R * sin($lat1)];
    $B = [$R * cos($lat2) * cos($lon2), $R * cos($lat2) * sin($lon2), $R * sin($lat2)];
    $P = [$R * cos($lat) * cos($lon), $R * cos($lat) * sin($lon), $R * sin($lat)];

    // Compute projection of P onto AB
    $AB = [$B[0]-$A[0], $B[1]-$A[1], $B[2]-$A[2]];
    $AP = [$P[0]-$A[0], $P[1]-$A[1], $P[2]-$A[2]];
    $t = max(0, min(1, ($AP[0]*$AB[0]+$AP[1]*$AB[1]+$AP[2]*$AB[2]) / ($AB[0]**2 + $AB[1]**2 + $AB[2]**2)));

    // Closest point on segment
    $closest = [$A[0]+$t*$AB[0], $A[1]+$t*$AB[1], $A[2]+$t*$AB[2]];

    // Distance between P and closest point
    return sqrt(($P[0]-$closest[0])**2 + ($P[1]-$closest[1])**2 + ($P[2]-$closest[2])**2);
}








public function get_all_events($search_key)
{
    $this->db->select('u.*,cf.city_name');
    $this->db->from('events u');
    $this->db->join('cities cf','u.event_city = cf.id','left');
    $this->db->where('u.event_date >=',date('Y-m-d'));
    $this->db->where('u.delete_status ',1);
    if(!empty($search_key)){
        $this->db->like('u.event_name ',$search_key);
    }
    $query= $this->db->get();
       // echo $this->db->last_query();exit;

    return $query->result_array();

}
public function get_all_featured_events($search_key)
{
    $this->db->select('u.*,cf.city_name');
    $this->db->from('events u');
    $this->db->join('cities cf','u.event_city = cf.id','left');
    $this->db->where('u.event_date >=',date('Y-m-d'));
    $this->db->where('u.delete_status ',1);
    $this->db->where('u.featured_event ','yes');
    if(!empty($search_key)){
        $this->db->like('u.event_name ',$search_key);
    }
    $query= $this->db->get();
    return $query->result_array();

}

public function user_all_modes($user_id)
{
    $this->db->select('u.id, u.name,
    IF(c.user_id IS NOT NULL, "1", "0") AS pal_mode,
    IF(v.user_id IS NOT NULL, "1", "0") AS par_mode,
    IF(a.user_id IS NOT NULL, "1", "0") AS pro_mode');
$this->db->from('users u');
$this->db->join('pal_registrations c', 'u.id = c.user_id', 'left');
$this->db->join('par_registrations v', 'u.id = v.user_id', 'left');
$this->db->join('pro_registrations a', 'u.id = a.user_id', 'left');
$this->db->where('u.id',$user_id);
$query = $this->db->get();

    return $query->result_array();

}


// public function get_all_zones_with_sample_point() {
//     $this->db->where('delete_status', 1);
//     $zones = $this->db->get('zones')->result_array();
//     $result = [];

//     foreach ($zones as $zone) {
//         // Use fresh query for boundary to avoid leftover conditions
//         $boundary = $this->db
//             ->select('latitude, longitude')
//             ->from('zone_boundaries')
//             ->where('zone_id', $zone['id'])
//             ->limit(1)
//             ->get()
//             ->row_array();

//         $result[] = [
//             'id'        => $zone['id'],
//             'name'      => $zone['name'],
//             'latitude'  => $boundary ? $boundary['latitude'] : null,
//             'longitude' => $boundary ? $boundary['longitude'] : null
//         ];
//     }

//     return $result;
// }

// public function get_all_zones_with_centroid() {
//     $this->db->where('delete_status', 1);
//     $zones = $this->db->get('zones')->result_array();
//     $result = [];

//     foreach ($zones as $zone) {
//         // Get all boundary points for this zone
//         $boundaries = $this->db
//             ->select('latitude, longitude')
//             ->from('zone_boundaries')
//             ->where('zone_id', $zone['id'])
//             ->get()
//             ->result_array();

//         // If boundaries exist, calculate centroid
//         if (!empty($boundaries)) {
//             $total_lat = 0;
//             $total_lng = 0;
//             $count = count($boundaries);

//             foreach ($boundaries as $point) {
//                 $total_lat += $point['latitude'];
//                 $total_lng += $point['longitude'];
//             }

//             $centroid_lat = $total_lat / $count;
//             $centroid_lng = $total_lng / $count;
//         } else {
//             $centroid_lat = null;
//             $centroid_lng = null;
//         }
//   $incount = $this->db
//             ->from('user_in_zone')
//             ->where('zone_id', $zone['id'])
//             ->where('status','in')
//             ->count_all_results();
//         $result[] = [
//             'id'        => $zone['id'],
//             'name'      => $zone['name'],
//             'latitude'  => $centroid_lat,
//             'longitude' => $centroid_lng,
//             'total_in_members' => $incount
//         ];
//     }

//     return $result;
// }

public function get_all_zones_with_centroid() {
    $this->db->where('delete_status', 1);
    $zones = $this->db->get('zones')->result_array();
    $result = [];

    foreach ($zones as $zone) {
        // Get all boundary points for this zone
        $boundaries = $this->db
            ->select('latitude, longitude')
            ->from('zone_boundaries')
            ->where('zone_id', $zone['id'])
            ->get()
            ->result_array();

        // If boundaries exist, calculate centroid
        if (!empty($boundaries)) {
            $total_lat = 0;
            $total_lng = 0;
            $count = count($boundaries);

            foreach ($boundaries as $point) {
                $total_lat += $point['latitude'];
                $total_lng += $point['longitude'];
            }

            $centroid_lat = round($total_lat / $count, 6);  // Round to 6 decimals
            $centroid_lng = round($total_lng / $count, 6);
        } else {
            $centroid_lat = null;
            $centroid_lng = null;
        }

        // Get count of users in this zone
        $incount = $this->db
            ->from('user_in_zone')
            ->where('zone_id', $zone['id'])
            ->where('status', 'in')
            ->count_all_results();

        $result[] = [
            'id'               => $zone['id'],
            'name'             => $zone['name'],
            'latitude'         => $centroid_lat,
            'longitude'        => $centroid_lng,
            'total_in_members' => $incount
        ];
    }

    return $result;
}


public function get_inzone_user_details($user_id,$zone_id,$mode,$gender)
{
    $this->db->select('iz.*,u.name as user_name,z.name as zone_name,iz.user_id as member_id');
    $this->db->from('user_in_zone iz');
    $this->db->join('users u','u.id = iz.user_id AND u.status = 1 AND u.delete_status = 1 AND u.sub_id >= 1','left');
    $this->db->join('zones z','z.id = iz.zone_id','left');
    $this->db->where('iz.user_id !=', $user_id);
    $this->db->where('iz.status','in');
    $this->db->where('iz.zone_id',$zone_id);
    $this->db->where('u.status',1);
    $this->db->where('u.delete_status',1);
    if(!empty($mode)){
        $this->db->where('iz.mode',$mode);
    } 
    if(!empty($gender)){
         $this->db->where('u.gender',$gender);
    }
    
        // Block check: exclude users blocked by or who blocked this user
    $this->db->where("iz.user_id NOT IN (
        SELECT blocked_user_id FROM blocked_users WHERE blocked_by_user_id = {$user_id}
        UNION
        SELECT blocked_by_user_id FROM blocked_users WHERE blocked_user_id = {$user_id}
    )", NULL, FALSE); // use FALSE to avoid escaping subquery


    $this->db->order_by('iz.created_on','asc');
    $query = $this->db->get();
    return $query->result_array();
}
public function get_pal_profile_pic($user_id)
{
    $this->db->select('pal.*,IFNULL(pi.image_link, " ") as image_link');
    $this->db->from('pal_registrations pal');
    $this->db->join('user_images pi','pi.user_type = "pal" ANd pi.user_type_id = pal.id','left');
    $this->db->where('pal.user_id',$user_id);
    $query = $this->db->get();
    return $query->result_array();
}

public function get_par_profile_pic($user_id)
{
    $this->db->select('par.*,IFNULL(pi.image_link, "") as image_link');
    $this->db->from('par_registrations par');
    $this->db->join('user_images pi','pi.user_type = "par" ANd pi.user_type_id = par.id','left');
    $this->db->where('par.user_id',$user_id);
    $query = $this->db->get();
    //echo $this->db->last_query();exit;
    return $query->result_array();
}

public function get_pro_profile_pic($user_id)
{
    $this->db->select('pro.*,IFNULL(pi.image_link, "") as image_link');
    $this->db->from('pro_registrations pro');
    $this->db->join('user_images pi','pi.user_type = "pro" ANd pi.user_type_id = pro.id','left');
    $this->db->where('pro.user_id',$user_id);
    $query = $this->db->get();
   // $this->db->last_query();
    return $query->result_array();
}

public function get_all_my_requests($user_id,$filter)
{
    // $this->db->select('DISTINCT fr.*,u.name');
    // $this->db->from('friend_requests fr');
    // $this->db->join('users u','u.id = fr.from_user_id','left');
    // $this->db->where('fr.to_user_id',$user_id);
    // $this->db->where('fr.status','request');
    // if(!empty($filter)){
    //     $this->db->where('fr.from_user_mode',$filter);
    // }
    // $query = $this->db->get();
    // return $query->result_array();
    
   $this->db->select('fr.*, u.name');
$this->db->from('friend_requests fr');
$this->db->join('users u', 'u.id = fr.from_user_id AND u.status = 1 AND u.delete_status = 1', 'left');
$this->db->where('fr.to_user_id', $user_id);
$this->db->where('u.status', 1);
$this->db->where('u.delete_status', 1);
$this->db->group_start();
$this->db->where('fr.status', 'request');
$this->db->or_where('fr.status', 'accepted');
$this->db->group_end();
if (!empty($filter)) {
    $this->db->where('fr.from_user_mode', $filter);
}

// Block check: exclude users blocked by or who blocked this user
    $this->db->where("fr.from_user_id NOT IN (
        SELECT blocked_user_id FROM blocked_users WHERE blocked_by_user_id = {$user_id}
        UNION
        SELECT blocked_by_user_id FROM blocked_users WHERE blocked_user_id = {$user_id}
    )", NULL, FALSE); // use FALSE to avoid escaping subquery

 $this->db->order_by('fr.id','desc');
$query = $this->db->get();
return $query->result_array();

}
public function get_all_my_friends($user_id,$filter)
{
    $this->db->select('fr.*,u.name');
    $this->db->from('friend_requests fr');
    $this->db->from('users u','u.id = fr.from_user_id','left');
    $this->db->where('fr.to_user_id',$user_id);
    $this->db->where('fr.status','accepted');
    if(!empty($filter)){
        $this->db->where('fr.mode',$filter);
    }
    $query = $this->db->get();
    return $query->result_array();
    
        $query = "
        SELECT u.id, u.name, u.email
        FROM users u
        JOIN friend_requests fr ON (
            (fr.from_user_id = ? AND fr.to_user_id = u.id) OR
            (fr.to_user_id = ? AND fr.from_user_id = u.id)
        )
        WHERE fr.status = 'accepted' AND fr.
    ";

    $friends = $this->db->query($query, [$user_id, $user_id])->result_array();

}

public function friend_request_sent_by_me($user_id,$filter)
{
    // Get users who were sent requests by this user and accepted
$this->db->select('users.id, users.name,friend_requests.*,friend_requests.to_user_mode as friend_mode,friend_requests.to_user_id as friend_id');
$this->db->from('users');
$this->db->join('friend_requests', 'friend_requests.to_user_id = users.id');
$this->db->where('users.status', 1);
$this->db->where('users.delete_status', 1);
$this->db->where('friend_requests.from_user_id', $user_id);
$this->db->where('friend_requests.status', 'accepted');
if(!empty($filter)){
    $this->db->where('friend_requests.to_user_mode', $filter);
}
// Block check: exclude users blocked by or who blocked this user
    $this->db->where("friend_requests.to_user_id NOT IN (
        SELECT blocked_user_id FROM blocked_users WHERE blocked_by_user_id = {$user_id}
        UNION
        SELECT blocked_by_user_id FROM blocked_users WHERE blocked_user_id = {$user_id}
    )", NULL, FALSE); // use FALSE to avoid escaping subquery
//$this->db->order_by('friend_requests.id','desc');
$friends1 = $this->db->get()->result_array();
return $friends1;
}

public function friend_request_sent_to_me($user_id,$filter)
{
    // Get users who sent requests to this user and were accepted
$this->db->select('users.id, users.name,friend_requests.*,friend_requests.from_user_mode as friend_mode,friend_requests.from_user_id as friend_id');
$this->db->from('users');
$this->db->join('friend_requests', 'friend_requests.from_user_id = users.id');
$this->db->where('users.status', 1);
$this->db->where('users.delete_status', 1);
$this->db->where('friend_requests.to_user_id', $user_id);
$this->db->where('friend_requests.status', 'accepted');
if(!empty($filter)){
    $this->db->where('friend_requests.from_user_mode', $filter);
}
// Block check: exclude users blocked by or who blocked this user
    $this->db->where("friend_requests.from_user_id NOT IN (
        SELECT blocked_user_id FROM blocked_users WHERE blocked_by_user_id = {$user_id}
        UNION
        SELECT blocked_by_user_id FROM blocked_users WHERE blocked_user_id = {$user_id}
    )", NULL, FALSE); // use FALSE to avoid escaping subquery
$friends2 = $this->db->get()->result_array();
return $friends2;
}


// public function get_nearby_zones($user_lat, $user_lon, $radius) {
//     $sql = "
//         SELECT 
//             z.*,
//             zb.latitude,
//             zb.longitude,
//             (
//                 6371 * acos(
//                     cos(radians(?)) * 
//                     cos(radians(zb.latitude)) * 
//                     cos(radians(zb.longitude) - radians(?)) + 
//                     sin(radians(?)) * 
//                     sin(radians(zb.latitude))
//                 )
//             ) AS distance
//         FROM zones z
//         JOIN (
//             SELECT zone_id, latitude, longitude 
//             FROM zone_boundaries 
//             GROUP BY zone_id
//         ) zb ON zb.zone_id = z.id
//         WHERE z.delete_status = 1
//         HAVING distance <= ?
//         ORDER BY distance ASC
//     ";

//     return $this->db->query($sql, [$user_lat, $user_lon, $user_lat, $radius])->result();
// }


    public function get_nearby_zones($user_lat, $user_lon, $radius) {
        // Validate inputs
        if (!is_numeric($user_lat) || !is_numeric($user_lon) || !is_numeric($radius)) {
            log_message('error', 'Invalid input parameters: lat=' . $user_lat . ', lon=' . $user_lon . ', radius=' . $radius);
            return [];
        }
        if ($user_lat < -90 || $user_lat > 90 || $user_lon < -180 || $user_lon > 180 || $radius <= 0) {
            log_message('error', 'Out-of-range input parameters: lat=' . $user_lat . ', lon=' . $user_lon . ', radius=' . $radius);
            return [];
        }

        $sql = "
            SELECT 
                z.*,
                zb.latitude,
                zb.longitude,
                (
                    6371 * acos(
                        cos(radians(?)) * 
                        cos(radians(zb.latitude)) * 
                        cos(radians(zb.longitude) - radians(?)) + 
                        sin(radians(?)) * 
                        sin(radians(zb.latitude))
                    )
                ) AS distance
            FROM zones z
            JOIN (
                SELECT zone_id, AVG(latitude) AS latitude, AVG(longitude) AS longitude
                FROM zone_boundaries
                GROUP BY zone_id
            ) zb ON zb.zone_id = z.id
            WHERE z.delete_status = 1 AND z.status = 1
            HAVING distance <= ?
            ORDER BY distance ASC LIMIT 6
        ";

        $query = $this->db->query($sql, [$user_lat, $user_lon, $user_lat, $radius]);
        if (!$query) {
            log_message('error', 'Database query failed in get_nearby_zones: ' . $this->db->_error_message());
            return [];
        }
        $result = $query->result();
        if (empty($result)) {
            log_message('info', 'No zones found within radius ' . $radius . ' for coordinates (' . $user_lat . ', ' . $user_lon . ')');
        }
        return $result;
    }
    
public function get_all_hottest_zones_with_centroid($city_id) {
    $this->db->where('delete_status', 1);
    $this->db->where('status', 1);
    $this->db->where('hottest_zone', 'yes');
    if(!empty($city_id))
    {
      $this->db->where('zone_city', $city_id);  
    }
    
    $zones = $this->db->get('zones')->result_array();
   // echo $this->db->last_query();exit;
    $result = [];

    foreach ($zones as $zone) {
        // Get all boundary points for this zone
        $boundaries = $this->db
            ->select('latitude, longitude')
            ->from('zone_boundaries')
            ->where('zone_id', $zone['id'])
            ->get()
            ->result_array();

        // If boundaries exist, calculate centroid
        if (!empty($boundaries)) {
            $total_lat = 0;
            $total_lng = 0;
            $count = count($boundaries);

            foreach ($boundaries as $point) {
                $total_lat += $point['latitude'];
                $total_lng += $point['longitude'];
            }

            $centroid_lat = $total_lat / $count;
            $centroid_lng = $total_lng / $count;
        } else {
            $centroid_lat = null;
            $centroid_lng = null;
        }

        $result[] = [
            'id'        => $zone['id'],
            'name'      => $zone['name'],
            'zone_logo'      => $zone['zone_logo'],
            'zone_pic'      => $zone['zone_pic'],
            'latitude'  => $centroid_lat,
            'longitude' => $centroid_lng
        ];
    }

    return $result;
}


public function get_user_in_zone_details($user_id)
{
    $this->db->select('user_in_zone.*,zones.name');
    $this->db->from('user_in_zone');
    $this->db->join('zones','zones.id = user_in_zone.zone_id','left');
    $this->db->where('user_in_zone.user_id',$user_id);
    $this->db->where('user_in_zone.status', 'in');
   // $this->db->where('incident_reports.incident_time <=',date('H:i:s'));
    $query = $this->db->get();
    return $query->result_array();
}

public function get_all_looking_fors_user($profile_id,$profile_type)
{
    $this->db->select('user_looking_for.*,looking_for.looking_for_name');
    $this->db->from('user_looking_for');
    $this->db->join('looking_for','looking_for.id = user_looking_for.looking_for_id','left');
    $this->db->where('user_looking_for.user_type_id',$profile_id);
    $this->db->where('user_looking_for.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}

public function get_all_interests_user($profile_id,$profile_type)
{
    $this->db->select('user_interests.*,interests.interest_name');
    $this->db->from('user_interests');
    $this->db->join('interests','interests.id = user_interests.interest_id','left');
    $this->db->where('user_interests.user_type_id',$profile_id);
    $this->db->where('user_interests.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_personality_traits_user($profile_id,$profile_type)
{
    $this->db->select('user_personality_traits.*,personality_traits.personality_traits_name');
    $this->db->from('user_personality_traits');
    $this->db->join('personality_traits','personality_traits.id = user_personality_traits.personality_traits_id','left');
    $this->db->where('user_personality_traits.user_type_id',$profile_id);
    $this->db->where('user_personality_traits.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}

public function get_all_preferences_user($profile_id,$profile_type)
{
    $this->db->select('user_preferences.*,preferences.preference_name');
    $this->db->from('user_preferences');
    $this->db->join('preferences','preferences.id = user_preferences.preference_id','left');
    $this->db->where('user_preferences.user_type_id',$profile_id);
    $this->db->where('user_preferences.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_foods_user($profile_id,$profile_type)
{
    $this->db->select('user_food.*,foods.food_name');
    $this->db->from('user_food');
    $this->db->join('foods','foods.id = user_food.food_id','left');
    $this->db->where('user_food.user_type_id',$profile_id);
    $this->db->where('user_food.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_activities_user($profile_id,$profile_type)
{
    $this->db->select('user_activities.*,activities.activity_name');
    $this->db->from('user_activities');
    $this->db->join('activities','activities.id = user_activities.activity_id','left');
    $this->db->where('user_activities.user_type_id',$profile_id);
    $this->db->where('user_activities.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_achievements_user($profile_id,$profile_type)
{
    $this->db->select('user_achievements.*,achievements.achievement_name');
    $this->db->from('user_achievements');
    $this->db->join('achievements','achievements.id = user_achievements.achievement_id','left');
    $this->db->where('user_achievements.user_type_id',$profile_id);
    $this->db->where('user_achievements.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}
public function get_all_professional_connections_user($profile_id,$profile_type)
{
    $this->db->select('user_professional_connections.*,professional_connections.connection_name');
    $this->db->from('user_professional_connections');
    $this->db->join('professional_connections','professional_connections.id = user_professional_connections.professional_connection_id','left');
    $this->db->where('user_professional_connections.user_type_id',$profile_id);
    $this->db->where('user_professional_connections.user_type', $profile_type);
    $query = $this->db->get();
    return $query->result_array();
}

public function get_user_languages($user_id)
{
    $this->db->select('user_languages.*,languages.language_name');
    $this->db->from('user_languages');
    $this->db->join('languages','languages.id = user_languages.language_id','left');
    $this->db->where('user_languages.user_id',$user_id);
    $query = $this->db->get();
    return $query->result_array();
}







}